
########################################################################
# floppyRS232popup() - Pop-up the dialog for RS232 settings
########################################################################
proc floppyRS232popup {} {
    global newRS232
    global RS232
    global tcl_platform

    set newRS232(speed) $RS232(speed)
    set newRS232(device) $RS232(device)

    set devicewin [[.rs232 childsite].device childsite]

    # set the right device - for windows it is automagically set

    if { $tcl_platform(platform) != "windows" } {
	$devicewin.device.path delete 0 end
	$devicewin.device.path insert 0 $newRS232(device)
	$devicewin.device.path xview moveto 1
    }

    .rs232 activate
}

########################################################################
# floppyRS232settingsOK() -	the function that is called when OK
#                               is pressed in the serial settings dialog,
#                               or return from the text entry field.
########################################################################
proc floppyRS232settingsOK {} {
    global newRS232
    global RS232
    global tcl_platform

    set bad_rs232_device_message \
"The file you have chosen doesn't look good.  Either
it doesn't exist, or it is not a character special
device, indicating that it isn't a serial port.
Are you sure you want that one?"

    if { $tcl_platform(platform) != "windows" } {
	set newRS232(device) [[[.rs232 childsite].device childsite].device.path get]
	if { ! [file readable $newRS232(device)] || \
		[file type $newRS232(device)] != "characterSpecial" } {
	    set answer [tk_messageBox -default cancel -icon error -title "ERROR"  \
		    -type okcancel -message $bad_rs232_device_message]
	    if { $answer == "cancel" } {
		return
	    }
	}
    }

    if { $RS232(device) != $newRS232(device) || \
	    $RS232(speed) != $newRS232(speed) } {
	set changed 1
    } else {
	set changed 0
    }

    set RS232(speed) $newRS232(speed)
    set RS232(device) $newRS232(device)

    serialClose

    if { [catch {serialOpen}] } {
	return
    }

    .rs232 deactivate

    if { $changed } {
	if { $tcl_platform(platform) == "windows" } {
	    iniSetAttribute "RS232" "Windows-Device" $RS232(device)
	    iniSetAttribute "RS232" "Windows-Speed" $RS232(speed)
	} else {
	    iniSetAttribute "RS232" "Unix-Device" $RS232(device)
	    iniSetAttribute "RS232" "Unix-Speed" $RS232(speed)
	}
    }
}

########################################################################
# floppyRS232settings() - creates the dialog for RS232 parameters
########################################################################
proc floppyRS232settings {} {
    global newRS232
    global RS232
    global tcl_platform

    iwidgets::dialogshell .rs232 -title "Set SVD Serial Interface" 

    .rs232 add OK -text "OK" -command { floppyRS232settingsOK }

    .rs232 add cancel -text "Cancel" -command {
	.rs232 deactivate
    }
    .rs232 add help -text "Help" -command {
	tk_messageBox -default ok -icon info -title "Help" -type ok -message \
		"In this dialog, you choose the RS232 paramters."
    }

    .rs232 default OK
    .rs232 configure -modality application

    set rs232win [.rs232 childsite]

    iwidgets::Labeledframe $rs232win.speed -labelpos nw -labeltext "RS232 Speed"
    set speedwin [$rs232win.speed childsite]

    frame $speedwin.middle
    frame $speedwin.right

    radiobutton $speedwin.middle.4800 -text "4800" -variable newRS232(speed) -value "4800"
    radiobutton $speedwin.middle.9600 -text "9600" -variable newRS232(speed) -value "9600"
    radiobutton $speedwin.middle.19200 -text "19200" -variable newRS232(speed) -value "19200"
    pack $speedwin.middle.4800 -side top -anchor w
    pack $speedwin.middle.9600 -side top -anchor w
    pack $speedwin.middle.19200 -side top -anchor w

    radiobutton $speedwin.right.38400 -text "38400" -variable newRS232(speed) -value "38400"
    radiobutton $speedwin.right.57600 -text "57600" -variable newRS232(speed) -value "57600"
    radiobutton $speedwin.right.115200 -text "115200" -variable newRS232(speed) -value "115200"
    pack $speedwin.right.38400 -side top -anchor w
    pack $speedwin.right.57600 -side top -anchor w
    pack $speedwin.right.115200 -side top -anchor w

    pack $speedwin.middle -side left -anchor w -padx 6 -fill x
    pack $speedwin.right -side left -anchor w -padx 6 -fill x

    iwidgets::Labeledframe $rs232win.device -labelpos nw -labeltext "RS232 Device"
    set devicewin [$rs232win.device childsite]

    frame $devicewin.device

    global availableSerialPorts

    if { $tcl_platform(platform) == "windows" } {

###########################################################
# I've been having a problem with tk_optionmenu...sometimes
# it won't select, and often the OK button won't work right
# after something has been selected.  I'm using the 
# iwidgets version now, because it appears to work BETTER
# although the same problem occasionally occurs.
# (this same work-around is in the file settings box too.)
# Note that the work-arounds during use are:
#   - hold down the mouse when selecting
#   - click OK, then move out of the button, do again
###########################################################

	iwidgets::optionmenu $devicewin.device.list -labeltext "Choose device:" -labelpos w \
	    -command { set newRS232(device) [[[.rs232 childsite].device childsite].device.list get]
#
# NEED SOMETHING HERE...can't figure out what... here's a few tries...didn't work...
#
#	               event generate [[.rs232 childsite].device childsite].device.list <Leave>
#	               .rs232.shellchildsite.bbox buttonconfigure OK -state disabled
#	               .rs232.shellchildsite.bbox buttonconfigure OK -state normal
 }
        pack $devicewin.device.list
        foreach i $availableSerialPorts { $devicewin.device.list insert end $i }

########################################
# the old way with tk_optionMenu
########################################
#	label $devicewin.device.label -text "Choose device:"
#	eval tk_optionMenu $devicewin.device.list newRS232(device) $availableSerialPorts
#	pack $devicewin.device.label -side left -anchor w -padx 6
#	pack $devicewin.device.list -side left -anchor w -padx 6 -fill x -expand yes

    } else {

	iwidgets::entryfield $devicewin.device.path \
		-highlightthickness 0 \
		-labelpos w \
		-labeltext "Device path:" \
		-textbackground "white" \
		-width 30 \
		-command { floppyRS232settingsOK }

	[$devicewin.device.path component label] configure -justify left -underline 0

	button $devicewin.device.browse -text "Browse..." -command {
	    set devicewin [[.rs232 childsite].device childsite]
	    set newfile [floppyRS232BrowseFiles .rs232 ""]
	    if { $newfile != "" } {
		$devicewin.device.path delete 0 end
		$devicewin.device.path insert 0 $newfile
		$devicewin.device.path xview moveto 1
	    }
	}

	pack $devicewin.device.path -side left -anchor w -expand yes -padx 6 -pady 6 -fill x
	pack $devicewin.device.browse -side left -anchor w -expand yes -padx 6 -pady 6 -fill x

    }

    pack $devicewin.device -side left -anchor w -expand yes -padx 6 -pady 6 -fill x
    pack $rs232win.speed -side top -anchor w
    pack $rs232win.device -side top -anchor w -expand yes -fill x

}
set floppyRS232FilesDir ""

########################################################################
# floppyRS232BrowseFiles() -	throws up a file selection box for the
#                               RS232 device (non-windows platforms)
########################################################################
proc floppyRS232BrowseFiles {win dir} {
    global floppyRS232FilesDir

    #   Type names		Extension(s)	Mac File Type(s)
    #
    #---------------------------------------------------------

    set types {
	{"All files"		*}
    }

    if { $dir == "" } { 
	if { $floppyRS232FilesDir == "" } {
		set dir "/dev"
	} else {
	    set dir $floppyRS232FilesDir
	}
    }

    set file [tk_getOpenFile -filetypes $types -parent $win \
	                      -initialdir $dir -title "Select RS232 device file"]

    if { $file != "" } {
	regexp {(.*/)[^/]*} $file match dir
	set floppyRS232FilesDir $dir
    }

    return $file
}
